package com.qboxus.tictic.activitesfragments.livestreaming.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import com.qboxus.tictic.R;

public class PkProgressBar extends View {
    private int firstSectionPercentage = 50;
    private int secondSectionPercentage = 50;


    public PkProgressBar(Context context) {
        super(context);
    }

    public PkProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PkProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public int getFirstSectionPercentage() {
        return firstSectionPercentage;
    }

    public void setFirstSectionPercentage(int percentage) {
        this.firstSectionPercentage = percentage;
        invalidate(); // invalidate the view to trigger a redraw
    }

    public int getSecondSectionPercentage() {
        return secondSectionPercentage;

    }

    public void setSecondSectionPercentage(int percentage) {
        this.secondSectionPercentage = percentage;
        invalidate(); // invalidate the view to trigger a redraw
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int firstSectionWidth = getWidth() * firstSectionPercentage / 100;
        int secondSectionWidth = getWidth() * secondSectionPercentage / 100;
        // draw the first section
        Paint paint = new Paint();
        paint.setColor(getContext().getResources().getColor(R.color.p_color));
        canvas.drawRect(0, 0, firstSectionWidth, getHeight(), paint);

        // draw the second section
        paint.setColor(getContext().getResources().getColor(R.color.k_color));
        canvas.drawRect(firstSectionWidth, 0, firstSectionWidth + secondSectionWidth, getHeight(), paint);


    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = MeasureSpec.getSize(widthMeasureSpec);
        int height = MeasureSpec.getSize(heightMeasureSpec);
        setMeasuredDimension(width, height);
    }


}